

!define MUI_PRODUCT "Your Company Name" ;Define your Business name here
!define MUI_VERSION "10.0" 

!include "MUI.nsh"


;--------------------------------
;Configuration

  ;General

  OutFile "ClientSetup.exe"
  XPStyle on
  
  InstallDir "$PROGRAMFILES\${MUI_PRODUCT}"
  
  
  InstallDirRegKey HKCU "Software\${MUI_PRODUCT}" ""

  !define MUI_STARTMENUPAGE_REGISTRY_ROOT "HKCU" 
  !define MUI_STARTMENUPAGE_REGISTRY_KEY "Software\${MUI_PRODUCT}" 
  !define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "Start Menu Folder"  

  !define TEMP $R0

;--------------------------------
;Modern UI Configuration

  !define MUI_WELCOMEPAGE
  !define MUI_LICENSEPAGE
  !define MUI_ICON "Updater\icond.ico" 
  !define MUI_UNICON "Updater\icond.ico"
  !define MUI_DIRECTORYPAGE
  !define MUI_STARTMENUPAGE
  !define MUI_FINISHPAGE
 !define MUI_FINISHPAGE_RUN "$INSTDIR\updater.exe"
 
  !define MUI_ABORTWARNING
  
  !define MUI_UNINSTALLER
  !define MUI_UNCONFIRMPAGE
  
;--------------------------------
;Languages
 
  !insertmacro MUI_LANGUAGE "English"
  
;--------------------------------
;Language Strings

  ;Description
  LangString DESC_SecCopyUI ${LANG_ENGLISH} "Copy the modern.exe file to the application folder."

;--------------------------------
;Data
  
  LicenseData "Updater\License.txt"
  
;--------------------------------
;Reserve Files

  ;Things that need to be extracted on first (keep these lines before any File command!)
  ;Only useful for BZIP2 compression
  !insertmacro MUI_RESERVEFILE_WELCOMEFINISHPAGE
  

;--------------------------------
;Installer Sections










Section "Updater.exe" SecCopyUI


  ;Add your stuff here

  SetOutPath "$INSTDIR"


  Setoverwrite on
  File "Updater\Updater.exe"

  File "Updater\Link.cur"
  File "Updater\ServUnin.exe"
  ;Store install folder
  WriteRegStr HKCU "Software\${MUI_PRODUCT}" "" $INSTDIR
    
  ;Create uninstaller
  WriteUninstaller "$INSTDIR\Uninstall.exe"

SectionEnd

Section "DataBase" SecCopyUpd

  SetOutPath "$INSTDIR"
  Setoverwrite off
  File "Updater\User.mdb"
SectionEnd



Section "Requi" Temper
  SetOutPath "$TEMP"
  Setoverwrite on
  File "Updater\vbrun60sp5.exe"

  SectionEnd

Section "WinDir" SecSys
  SetOutPath "$SYSDIR"
  Setoverwrite off
  File "Updater\NTSVC.ocx"
  File "Updater\TABCTL32.OCX"
  File "Updater\MSINET.OCX"
  RegDLL "$SYSDIR\MSINET.OCX"
  RegDLL "$SYSDIR\NTSVC.ocx"
  RegDLL "$SYSDIR\TABCTL32.OCX"

SectionEnd

Section "WinDirOver" SecSys1
  SetOutPath "$SYSDIR"
  Setoverwrite off
  File "Updater\COMCT332.OCX"
  File "Updater\MSCOMCTL.OCX"
  RegDLL "$SYSDIR\COMCT332.OCX"
  RegDLL "$SYSDIR\MSCOMCTL.OCX"


SectionEnd









Section "AddRunTim" TemperTemper

    ExecWait "$TEMP\vbrun60sp5.exe /q"


SectionEnd
 Section "GetWindowsVersion" InstWin
   Push $R0
   Push $R1
   ReadRegStr $R0 HKLM "SOFTWARE\Microsoft\Windows NT\CurrentVersion" CurrentVersion
   StrCmp $R0 "" 0 lbl_winnt
   ; we are not NT.
   ReadRegStr $R0 HKLM SOFTWARE\Microsoft\Windows\CurrentVersion VersionNumber

   StrCpy $R1 $R0 1
   StrCmp $R1 '4' 0 lbl_error

   StrCpy $R1 $R0 3

   StrCmp $R1 '4.0' lbl_win32_95
   StrCmp $R1 '4.9' lbl_win32_ME lbl_win32_98

   lbl_win32_95:
     StrCpy $R0 '95'

   Goto lbl_error

   lbl_win32_98:
     StrCpy $R0 '98'

   Goto lbl_done

   lbl_win32_ME:
     StrCpy $R0 'ME'

    Goto lbl_done

   lbl_winnt:

     StrCpy $R1 $R0 1

     StrCmp $R1 '3' lbl_winnt_x
     StrCmp $R1 '4' lbl_winnt_x

     StrCpy $R1 $R0 3

     StrCmp $R1 '5.0' lbl_winnt_2000
     StrCmp $R1 '5.1' lbl_winnt_XP
     StrCmp $R1 '5.2' lbl_winnt_dotNET lbl_error

     lbl_winnt_x:
       StrCpy $R0 "NT $R0" 6

     Goto lbl_error

     lbl_winnt_2000:
       Strcpy $R0 '2000'

    Goto lbl_done

     lbl_winnt_XP:
       Strcpy $R0 'XP'

     Goto lbl_done

     lbl_winnt_dotNET:
       Strcpy $R0 '.NET Server'

       Goto lbl_done
  


   lbl_error:
MessageBox MB_YESNO|MB_ICONQUESTION "This software requires MDAC 2.5 would you like to download and install MDAC 2.5 now.$\nThis download may be unnecessary if you have Internet Explorer 5.0 or later installed.$\nIf you choose no and this application does not operate correctly download and install MDAC 2.5" IDYES YesInstall IDNO NoAbort

YesInstall:
StrCmp $R0 "95" Beeoch 

   NSISdl::download /TIMEOUT=30000 http://download.microsoft.com/download/dasdk/SP/2.51/W9XNT4/EN-US/MDAC_TYP.EXE "$TEMP\MDAC_TYP.EXE" 
   ExecWait "$TEMP\MDAC_TYP.EXE /q"
Goto lbl_done
Beeoch:
   NSISdl::download /TIMEOUT=30000 http://download.microsoft.com/msdownload/dcom/95/x86/en/dcom95.exe "$TEMP\dcom95.exe" 
   NSISdl::download /TIMEOUT=30000 http://download.microsoft.com/download/dasdk/SP/2.51/W9XNT4/EN-US/MDAC_TYP.EXE "$TEMP\MDAC_TYP.EXE" 
   ExecWait "$TEMP\dcom95.exe /q"
   ExecWait "$TEMP\MDAC_TYP.EXE /q"
Goto lbl_done
NoAbort:
   lbl_done:

   Pop $R1
   Exch $R0

SectionEnd  



Section "CreateShOrt" Dingle
!insertmacro MUI_STARTMENU_WRITE_BEGIN
CreateDirectory "$SMPROGRAMS\${MUI_STARTMENUPAGE_VARIABLE}"
    CreateShortCut "$SMPROGRAMS\${MUI_STARTMENUPAGE_VARIABLE}\DNS Updater.lnk" "$INSTDIR\Updater.exe"
    CreateShortCut "$SMPROGRAMS\${MUI_STARTMENUPAGE_VARIABLE}\Uninstall.lnk" "$INSTDIR\Uninstall.exe"

!insertmacro MUI_STARTMENU_WRITE_END
SectionEnd  
Section "Deskt" SecMenuDesk2
			CreateShortCut  "$DESKTOP\Dns Updater.lnk"  "$INSTDIR\Updater.exe" "" "$INSTDIR\Updater.exe" 0
sectionend

;--------------------------------
;Descriptions

!insertmacro MUI_FUNCTIONS_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SecCopyUI} $(DESC_SecCopyUI)
!insertmacro MUI_FUNCTIONS_DESCRIPTION_END

;--------------------------------
;Uninstaller Section

Section "Uninstall"

  ;Add your stuff here
  ExecWait "$INSTDIR\ServUnin.exe"
  Delete "$INSTDIR\updater.exe"
  Delete "$INSTDIR\User.mdb"
  Delete "$INSTDIR\Link.cur"
  Delete "$INSTDIR\ServUnin.exe"
  Delete "$INSTDIR\Uninstall.exe"
  Delete "$DESKTOP\Dns Updater.lnk"
  ;Remove shortcut
  ReadRegStr ${TEMP} "${MUI_STARTMENUPAGE_REGISTRY_ROOT}" "${MUI_STARTMENUPAGE_REGISTRY_KEY}" "${MUI_STARTMENUPAGE_REGISTRY_VALUENAME}"
  
  StrCmp ${TEMP} "" noshortcuts
  
    Delete "$SMPROGRAMS\${TEMP}\DNS Updater.lnk"
    Delete "$SMPROGRAMS\${TEMP}\Uninstall.lnk"
    RMDir "$SMPROGRAMS\${TEMP}" ;Only if empty, so it won't delete other shortcuts
    
  noshortcuts:



  RMDir "$INSTDIR"

  DeleteRegKey /ifempty HKCU "Software\${MUI_PRODUCT}"

  !insertmacro MUI_UNFINISHHEADER

SectionEnd